<%--
/*
 * MosP - Mind Open Source Project         http://www.mosp.jp/
 * Copyright (C) 1987-2009 MIND Co., Ltd.  http://www.e-mind.co.jp/
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
--%>
<%@ page
language     = "java"
pageEncoding = "Windows-31J"
buffer       = "256kb"
autoFlush    = "false"
errorPage    = "/jsp/common/error.jsp"
%><%@ page
import = "jp.mosp.common.common.MospConst"
import = "jp.mosp.common.common.HtmlUtility"
import = "jp.mosp.payroll.base.PayrollConst"
import = "jp.mosp.payroll.common.vo.ImportMasterCardVo"
%><%
ImportMasterCardVo vo	= (ImportMasterCardVo)request.getAttribute(MospConst.ATT_VO);
String[] aryICode		= vo.getAryHidIField();
String[] aryIName		= vo.getAryLblIField();
String[] aryIOrder		= vo.getAryPltIOrder();
%>
<%= HtmlUtility.getHeader(vo) %>
<%= HtmlUtility.getSubTitle(vo) %>
<div class="Body" id="ImportMasterCard">
	<%= HtmlUtility.getMessages(vo) %>
	<div class="Card">
		<table>
			<tr>
				<td class="TitleTd">
					<%= HtmlUtility.getRequiredMark() %><%= ImportMasterCardVo.NAM_I_CODE %><%= vo.getName("C_SEPARATOR") %>
				</td>
				<td>
					<input type="text" class="CodeTextBox" id="<%= ImportMasterCardVo.PRM_TXT_I_CODE %>" name="<%= ImportMasterCardVo.PRM_TXT_I_CODE %>" value="<%= vo.getEscTxtICode() %>" />
				</td>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= HtmlUtility.getRequiredMark() %><%= ImportMasterCardVo.NAM_I_NAME %><%= vo.getName("C_SEPARATOR") %>
				</td>
				<td>
					<input type="text" class="TextBox" id="<%= ImportMasterCardVo.PRM_TXT_I_NAME %>" name="<%= ImportMasterCardVo.PRM_TXT_I_NAME %>" value="<%= vo.getEscTxtIName() %>" />
				</td>
			</tr>
			<tr>
				<td class="TitleTd">
					<%= vo.getName("P_IMPORT") %><%= vo.getName("P_TABLE") %><%= vo.getName("C_SEPARATOR") %>
				</td>
				<td>
					<%= vo.getLblITable() %>
					<input type="hidden" id="<%= ImportMasterCardVo.PRM_HID_I_TABLE %>" name="<%= ImportMasterCardVo.PRM_HID_I_TABLE %>" value="<%= vo.getEscHidITable() %>" />
				</td>
			</tr>
<%
for (int i = 0; i < aryICode.length; i++) {
%>
			<tr>
				<td class="TitleTd">
					<%= vo.getRequiredMark(aryICode[i]) %><%= aryIName[i] %><%= vo.getName("C_SEPARATOR") %>
					<input type="hidden" id="<%= ImportMasterCardVo.PRM_HID_I_FIELD %>" name="<%= ImportMasterCardVo.PRM_HID_I_FIELD %>" value="<%= aryICode[i] %>" />
				</td>
				<td>
					<select id="<%= ImportMasterCardVo.PRM_PLT_I_ORDER %>" name="<%= ImportMasterCardVo.PRM_PLT_I_ORDER %>">
						<option value=""></option>
						<%= HtmlUtility.getSelectOption(vo.aryPltOrder, aryIOrder[i]) %>
					</select>
				</td>
			</tr>
<%
}
%>
		</table>
	</div>
</div>
<div class="Footer">
	<button type="button" class="ExecuteButton" onclick="submitForm(document.form)"><%= vo.getName("C_REGIST") %></button>
	<button type="button" class="ExecuteButton" id="btnDelete" onclick="doSubmitMessage(document.form,'P9034','QC0002','')"><%= vo.getName("C_DELETE") %></button>
	<button type="button" class="ExecuteButton" onclick="doSubmit(document.form,'P9022')"><%= vo.getName("C_LIST") %><%= vo.getName("C_TO") %></button>
	<button type="button" class="ExecuteButton" id="btnNewData" onclick="doSubmitKey(document.form, 'P9030', '<%= vo.getEscHidITable() %>', '')"><%= vo.getName("P_MAKE_NEW_DATA") %></button>
</div>
<%=HtmlUtility.getFooter(vo) %>	
